
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data to create contour lines for tourism density and satisfaction
x = np.linspace(0, 100, 150)
y = np.linspace(0, 50, 150)
X, Y = np.meshgrid(x, y)
Z1 = np.exp(-((X - 20) ** 2 + (Y - 25) ** 2) / 300)  # Tourist Density
Z2 = np.exp(-((X - 70) ** 2 + (Y - 35) ** 2) / 200)  # Tourist Satisfaction

# Labels and texts
labels = ["Tourist Density", "Tourist Satisfaction"]
xlabel = "Region Distance (km)"
ylabel = "Tourism Level"
title = "Tourism Data Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_loc = "upper right"
legend_fontsize = 10
xlabel_fontsize = 12
ylabel_fontsize = 12
title_fontsize = 16
fontweight = "bold"

# Create the plot
fig, ax = plt.subplots(figsize=(12, 10))

# Contour lines for Tourist Density (green) and Tourist Satisfaction (blue)
CS1 = ax.contour(
    X, Y, Z1, colors="green", linestyles="-", linewidths=1.5, label=labels[0]
)
CS2 = ax.contour(
    X, Y, Z2, colors="blue", linestyles="--", linewidths=1.5, label=labels[1]
)

# Labels for x and y axes
plt.xlabel(xlabel, fontsize=xlabel_fontsize, fontweight=fontweight)
plt.ylabel(ylabel, fontsize=ylabel_fontsize, fontweight=fontweight)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, loc=legend_loc, fontsize=legend_fontsize)

# Set the aspect of the plot to match the original image
ax.set_aspect("auto")
ax.grid(True)
ax.set_facecolor("#f0f8ff")  # Alice blue background
ax.set_xlim(0, 100)
ax.set_ylim(0, 50)

# Title of the plot
plt.title(title, fontsize=title_fontsize, fontweight=fontweight)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_79.pdf", bbox_inches="tight")
