
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulated Economic Data
years = np.linspace(1990, 2020, 100)
gdp_growth = 1 / (1 + np.exp(-0.1 * (years - 2000)))
inflation_rate = 0.8 * np.exp(-0.5 * ((years - 2005) ** 2) / 50)

# Text labels and chart parameters
xlabel = "Year"
ylabel = "Rate"
title = "Economic Trends: GDP Growth and Inflation Rate (1990-2020)"
legend_labels = ["GDP Growth", "Inflation Rate"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the data
ax.plot(years, gdp_growth, label=legend_labels[0], color="#1f77b4", linewidth=2)
ax.fill_between(years, 0, gdp_growth, color="#1f77b4", alpha=0.3)

ax.plot(years, inflation_rate, label=legend_labels[1], color="#ff7f0e", linewidth=2)
ax.fill_between(years, 0, inflation_rate, color="#ff7f0e", alpha=0.3)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_25.pdf", bbox_inches="tight")

