
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

from scipy.stats import gaussian_kde

# Generate synthetic religiosity scores data for two subgroups
data1 = np.random.normal(loc=40, scale=10, size=500)
data2 = np.random.normal(loc=70, scale=10, size=500)
data = np.concatenate([data1, data2])
xs = np.linspace(0, 110, 200)

# Axes Limits and Labels
xticks_values = [0, 20, 40, 60, 80, 100]
xticklabels = ["0", "20", "40", "60", "80", "100"]
yticks_values = [0, 0.01, 0.02, 0.03, 0.04, 0.05]
yticklabels = ["0.00", "0.01", "0.02", "0.03", "0.04", "0.05"]
xlim_values = [0, 110]
ylim_values = [0, 0.05]
title = "KDE Plot of Religiosity Scores Distribution"
xlabel_value = "Religiosity Score"
ylabel_value = "Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(10, 6))

# Create the KDE plot with adjusted x-axis range
density = gaussian_kde(data)
density.covariance_factor = lambda: 0.5
density._compute_covariance()
plt.fill_between(xs, density(xs), color="#e4d2ff", edgecolor="#8c2c92", linewidth=2)

ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)

ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)

plt.xlim(xlim_values)
plt.ylim(ylim_values)
# Set the title and labels
plt.title(title, fontsize=14, fontweight='bold')
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_29.pdf", bbox_inches="tight")
