
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

from scipy.stats import gaussian_kde

# Sample data for communication domain
signal_strength = np.random.normal(loc=20, scale=2, size=1000)
noise_level = np.random.normal(loc=5, scale=1.2, size=1000)
bandwidth_usage = np.random.normal(loc=12, scale=1.8, size=1000)
labels = ["Signal Strength", "Noise Level", "Bandwidth Usage"]
reserved_label = "Optimal Signal Threshold"
xlabel = "Measurement Value"
ylabel = "Density"
chart_title = "Communication Metrics Density Distribution"
legend_labels = ["Signal Strength", "Noise Level", "Bandwidth Usage", "Optimal Signal Threshold"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Color scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]

# Plot the density plots
for data, color, label in zip(
    [signal_strength, noise_level, bandwidth_usage],
    colors,
    labels
):
    density = gaussian_kde(data)
    xs = np.linspace(0, 30, 200)
    density.covariance_factor = lambda: 0.5
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.3, label=label)

# Plot the reserved price line
plt.axvline(x=15, color="purple", linestyle="--", label=reserved_label)

# Set labels and title
ax.set_xlim(0, 30)
ax.set_xticks(np.arange(0, 31, 5))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(chart_title)

# Show grid
plt.grid(True, linestyle="--")

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_30.pdf", bbox_inches="tight")

