
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

from scipy.stats import gaussian_kde

# Generate new data reflecting business trends
revenue_growth = np.random.normal(loc=15, scale=2, size=1000)
cost_reduction = np.random.normal(loc=8, scale=1.5, size=1000)
profit_margin = np.random.normal(loc=10, scale=0.75, size=1000)
labels = ["Revenue Growth", "Cost Reduction", "Profit Margin"]
xlabel = "Value"
ylabel = "Density"
avxlabel = "Target Value"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(
    figsize=(10, 6)
)  # Adjusted to match the original image's dimensions

# Plot the density plots
for data, color, label in zip(
    [revenue_growth, cost_reduction, profit_margin],
    ["#1f77b4", "#ff7f0e", "#2ca02c"],  # Using distinct colors
    labels,
):
    density = gaussian_kde(data)
    xs = np.linspace(4, 20, 200)
    density.covariance_factor = lambda: 0.5
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.3, label=label)

# Plot the reserved price line
plt.axvline(x=12.0, color="purple", linestyle="--", label=avxlabel)

# Set labels and title (if any)
ax.set_xlim(4, 20)
ax.set_xticks([4, 6, 8, 10, 12, 14, 16, 18, 20])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Show grid
plt.grid(True, linestyle="--")

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_31.pdf", bbox_inches="tight")
