
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample data for three cities
city_a = np.random.normal(loc=15, scale=5, size=1000)
city_b = np.random.normal(loc=20, scale=7, size=1000)
city_c = np.random.normal(loc=25, scale=6, size=1000)
labels = ["City A", "City B", "City C"]
xlabel = "Temperature (°C)"
ylabel = "Density"
title = "Temperature Distributions Across Three Cities"
avxlabel = "Average Temperature"
reserved_temp = 20  # Example of an average temperature line

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Plot the density plots
for data, color, label in zip(
    [city_a, city_b, city_c],
    ["#1f77b4", "#2ca02c", "#ff7f0e"],  # Blue, Green, Orange
    labels,
):
    density = gaussian_kde(data)
    xs = np.linspace(0, 40, 200)
    density.covariance_factor = lambda: 0.5
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.5, label=label)

# Plot the average temperature line
plt.axvline(x=reserved_temp, color="black", linestyle="--", label=avxlabel)

# Set labels and title
ax.set_xlim(0, 40)
ax.set_xticks(np.arange(0, 41, 5))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid with custom styling
plt.grid(True, linestyle="--", alpha=0.7)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_32.pdf", bbox_inches="tight")
