# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
# ===================
# Part 2: Data Preparation - Movie Ratings Data
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(42)
x = np.linspace(0, 15, 600)  # Simulate days
genres = ['Action', 'Comedy', 'Drama', 'Thriller', 'Romance', 'Horror', 'Sci-Fi']
y = [
    np.random.uniform(4, 8) + np.sin(x - i) * np.random.uniform(0.2, 1.0)
    for index, i in enumerate(np.linspace(0, 15, len(genres)))
]

# Combine data for density estimation
data = np.concatenate(y)

# Kernel Density Estimation (KDE) for the movie ratings data
kde = gaussian_kde(data, bw_method='scott')
x_dens = np.linspace(3, 9, 1000)
density = kde(x_dens)

# Extracted variables for the density plot
xlabel_text = "Movie Rating"
ylabel_text = "Density"
title_text = "Density of Movie Ratings Across Different Genres Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 7))

# Plot the density curve for movie ratings
ax.plot(x_dens, density, color='purple', lw=2, label='Overall Rating Density')
ax.fill_between(x_dens, density, color='purple', alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc='upper right')

# ===================
# Part 4: Saving Output for Density Plot
# ===================
plt.tight_layout()
plt.savefig("density_42.pdf", bbox_inches="tight")
