# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation - Exam Scores Data
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(42)
# Simulated exam scores for three different subjects
scores_math = np.random.normal(75, 10, 300)
scores_science = np.random.normal(80, 12, 300)
scores_history = np.random.normal(70, 15, 300)

# Combine data for density estimation
scores_data_1 = scores_math
scores_data_2 = scores_science
scores_data_3 = scores_history

# Kernel Density Estimation (KDE) for the exam scores data
kde_scores_1 = gaussian_kde(scores_data_1, bw_method='scott')
kde_scores_2 = gaussian_kde(scores_data_2, bw_method='scott')
kde_scores_3 = gaussian_kde(scores_data_3, bw_method='scott')

x_dens_scores = np.linspace(min(min(scores_data_1), min(scores_data_2), min(scores_data_3)), 
                            max(max(scores_data_1), max(scores_data_2), max(scores_data_3)), 1000)
density_scores_1 = kde_scores_1(x_dens_scores)
density_scores_2 = kde_scores_2(x_dens_scores)
density_scores_3 = kde_scores_3(x_dens_scores)

# Extracted variables for the density plot
xlabel_text = "Exam Scores"
ylabel_text = "Density"
title_text = "Density of Exam Scores Across Different Subjects"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 5))

# Plot the density curves for exam scores data
ax.plot(x_dens_scores, density_scores_1, color='purple', lw=2, label='Math Density')
ax.fill_between(x_dens_scores, density_scores_1, color='purple', alpha=0.3)

ax.plot(x_dens_scores, density_scores_2, color='orange', lw=2, label='Science Density')
ax.fill_between(x_dens_scores, density_scores_2, color='orange', alpha=0.3)

ax.plot(x_dens_scores, density_scores_3, color='brown', lw=2, label='History Density')
ax.fill_between(x_dens_scores, density_scores_3, color='brown', alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc='upper right')

# ===================
# Part 4: Saving Output for Density Plot
# ===================
plt.tight_layout()
plt.savefig("density_50.pdf", bbox_inches="tight")
