
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Generating new data representing daily returns for two stocks
stock1_returns = np.random.normal(loc=0, scale=0.02, size=1000)
stock2_returns = np.random.normal(loc=0, scale=0.025, size=1000)

# Extracted strings
title_text = "Density Distribution of Daily Stock Returns"
xlabel_text = "Daily Return (%)"
ylabel_text = "Density"
legend_label1 = "Stock 1"
legend_label2 = "Stock 2"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(12, 7))  # Adjusted for better readability

# Adding a line for the true distribution (assuming normal for illustration)
x = np.linspace(min(stock1_returns.min(), stock2_returns.min()), max(stock1_returns.max(), stock2_returns.max()), 300)
stock1_pdf = (1 / (np.sqrt(2 * np.pi) * 0.02)) * np.exp(-((x) ** 2) / (2 * 0.02**2))
stock2_pdf = (1 / (np.sqrt(2 * np.pi) * 0.025)) * np.exp(-((x) ** 2) / (2 * 0.025**2))
ax.plot(x, stock1_pdf, color='green', linestyle="-", linewidth=2, label=legend_label1)
ax.plot(x, stock2_pdf, color='red', linestyle="-", linewidth=2, label=legend_label2)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, which='both', linestyle='--', linewidth=0.5)

# Add title and labels
ax.set_title(title_text, fontsize=18)
ax.set_xlabel(xlabel_text, fontsize=16)
ax.set_ylabel(ylabel_text, fontsize=16)
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_52.pdf", bbox_inches="tight")
