# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation - Rainfall Data
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(42)
seasons = ['Spring', 'Summer', 'Autumn', 'Winter']
rainfall = [np.random.normal(loc=60 + i*30, scale=20, size=300) for i in range(4)]

# Combine all seasonal rainfall data for density estimation
all_rainfall = np.concatenate(rainfall)

# Kernel Density Estimation (KDE) for the rainfall data
kde_rainfall = gaussian_kde(all_rainfall, bw_method='scott')
x_dens_rainfall = np.linspace(min(all_rainfall), max(all_rainfall), 1000)
density_rainfall = kde_rainfall(x_dens_rainfall)

# Extracted variables for the density plot
xlabel_text = "Rainfall (mm)"
ylabel_text = "Density"
title_text = "Density of Rainfall Across Different Seasons"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 5))

# Plot the density curve for rainfall
ax.plot(x_dens_rainfall, density_rainfall, color='blue', lw=2, label='Rainfall Density')
ax.fill_between(x_dens_rainfall, density_rainfall, color='blue', alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_55.pdf", bbox_inches="tight")
