
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Create energy data
years = np.linspace(2000, 2020, 100)  # Years from 2000 to 2020
energy_consumption = 2 + 0.05 * (years - 2000) + 0.1 * np.sin(0.5 * (years - 2000)) # Increasing energy consumption with slight fluctuation
renewable_energy = 0.3 + 0.02 * (years - 2000) * np.exp(0.03 * (years - 2010))  # Increasing renewable energy production

# Text variables
xlabel_text = "Year"
ylabel_text = "Energy (in Exajoules)"
title_text = "Energy Consumption and Renewable Energy Production Over the Years"
legend_energy_consumption = "Energy Consumption"
legend_renewable_energy = "Renewable Energy Production"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper left"
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the data
ax.fill_between(
    years,
    energy_consumption,
    color="#1f77b4",
    edgecolor="#1f77b4",
    alpha=0.6,
    label=legend_energy_consumption,
)
ax.fill_between(
    years,
    renewable_energy,
    color="#2ca02c",
    edgecolor="#2ca02c",
    alpha=0.6,
    label=legend_renewable_energy,
)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.set_xlabel(xlabel_text)
ax.set_ylabel(ylabel_text)
ax.set_title(title_text)
ax.set_ylim(0, max(energy_consumption) + 0.5)
ax.set_facecolor("#f9f9f9")
ax.grid(True, linestyle='--', alpha=0.7)

# Add legend
ax.legend(loc=legend_location)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_58.pdf", bbox_inches="tight")
