
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

# Set random seed for reproducibility
np.random.seed(100)

# Generate a normal distribution simulating crop yields
yield1 = np.random.normal(loc=50, scale=10, size=500)   # Crop A
yield2 = np.random.normal(loc=80, scale=20, size=300)   # Crop B
crop_yield_data = np.concatenate([yield1, yield2])
xs = np.linspace(0, 150, 300)

# Axes Limits and Labels
title = "KDE Plot of Crop Yield Distribution"
xlabel_value = "Yield Amount (in tons)"
ylabel_value = "Density"

xticks_values = [0, 30, 60, 90, 120, 150]
xticklabels = ["0", "30", "60", "90", "120", "150"]
yticks_values = [0, 0.005, 0.01, 0.015, 0.02]
yticklabels = ["0.0", "0.005", "0.01", "0.015", "0.02"]
xlim_values = [0, 150]
ylim_values = [0, 0.025]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Set the figure size
fig, ax = plt.subplots(figsize=(10, 5))

# Create the KDE plot with adjusted x-axis range
density = gaussian_kde(crop_yield_data)
density.covariance_factor = lambda: 0.25
density._compute_covariance()
plt.fill_between(xs, density(xs), color="#a2d5c6", edgecolor="#4b9b8a")

ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)

ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)

plt.xlim(xlim_values)
plt.ylim(ylim_values)
# Set the title and labels
plt.title(title, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_65.pdf", bbox_inches="tight")
