
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for tech product launches marketing strategies
email_campaign = np.random.normal(loc=14, scale=1.3, size=1500)
ad_campaign = np.random.normal(loc=18, scale=1.1, size=1500)
influencer_campaign = np.random.normal(loc=16, scale=1.4, size=1500)
labels = ["Email Campaign", "Ad Campaign", "Influencer Campaign"]
avxlabel = "Optimal ROI Threshold"
xlabel = "Marketing Strategy Effectiveness"
ylabel = "Density"
title = "Density Plot of Tech Product Launch Marketing Strategies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the density plots
for data, color, label in zip(
    [email_campaign, ad_campaign, influencer_campaign],
    ["#ff7f0e", "#2ca02c", "#d62728"],  # Modern tech theme colors
    labels,
):
    density = gaussian_kde(data)
    xs = np.linspace(9.0, 22.0, 200)
    density.covariance_factor = lambda: 0.5
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.4, label=label)

# Plot the optimal threshold line
plt.axvline(x=15.5, color="purple", linestyle="--", linewidth=2, label=avxlabel)

# Set labels and title (if any)
ax.set_xlim(9.0, 23.0)
ax.set_xticks(range(9, 24))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
plt.grid(True, linestyle="--", alpha=0.6)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_73.pdf", bbox_inches="tight")
