
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for yearly temperature readings in three cities
city_a_temps = np.random.normal(loc=15, scale=5, size=1500)
city_b_temps = np.random.normal(loc=25, scale=7, size=1500)
city_c_temps = np.random.normal(loc=10, scale=3, size=1500)
labels = ["City A Temperatures", "City B Temperatures", "City C Temperatures"]
avxlabel = "Average Comfortable Temperature"
xlabel = "Temperature (°C)"
ylabel = "Density"
title = "Density Plot of Yearly Temperature Readings in Three Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Updated color scheme
colors = ["#FF5733", "#33FFBD", "#337BFF"]

# Plot the density plots
for data, color, label in zip(
    [city_a_temps, city_b_temps, city_c_temps],
    colors,
    labels,
):
    density = gaussian_kde(data)
    xs = np.linspace(-10.0, 40.0, 200)
    density.covariance_factor = lambda: 0.4
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.3, label=label)
    plt.plot(xs, density(xs), color=color, linewidth=2)

# Plot the average comfortable temperature line
plt.axvline(x=22.0, color="orange", linestyle="--", linewidth=2, label=avxlabel)

# Set labels and title (if any)
ax.set_xlim(-10.0, 40.0)
ax.set_xticks(range(-10, 41, 5))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
plt.grid(True, linestyle="--", linewidth=0.7, alpha=0.7)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_74.pdf", bbox_inches="tight")
