
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define regions as groups
regions = [
    "North America",
    "Europe",
    "Asia",
    "South America",
    "Africa",
    "Australia",
    "Central America",
    "Middle East",
    "Southeast Asia",
    "Scandinavia",
]

# Energy data: Renewable Energy Production (solid_bar) and Non-Renewable Energy Production (striped_bar)
renewable_production = (
    np.random.rand(10) * 20 + 40
)  # Renewable production ranging from 40% to 60%
non_renewable_production = (
    np.random.rand(10) * 30 + 20
)  # Non-renewable production ranging from 20% to 50%

# Errors for both metrics
renewable_errors = np.random.rand(10) * 5 + 3  # Error bars for renewable production
non_renewable_errors = np.random.rand(10) * 7 + 4  # Error bars for non-renewable production

# Labels and Plot Types
label_Renewable_Energy = "Renewable Energy Production"
label_Non_Renewable_Energy = "Non-Renewable Energy Production"

# Axes Limits and Labels
ylabel_value = "Energy Production (%)"
title = "Energy Production Metrics by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(12, 7))

# X-axis positions for the bars
x = np.arange(len(regions))

# Custom colors
color_renewable = "#4CAF50"  # Green
color_non_renewable = "#A9A9A9"  # Gray

# Create vertical stacked bar chart
ax.bar(
    x,
    renewable_production,
    color=color_renewable,
    yerr=renewable_errors,
    label=label_Renewable_Energy,
    capsize=5,
    edgecolor='black'
)
ax.bar(
    x,
    non_renewable_production,
    bottom=renewable_production,
    color=color_non_renewable,
    yerr=non_renewable_errors,
    label=label_Non_Renewable_Energy,
    capsize=5,
    edgecolor='black'
)

# Add labels and title
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(regions, rotation=45, ha="right")
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_101.pdf", bbox_inches="tight")
