
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
companies = ["Company A", "Company B", "Company C", "Company D"]
revenue_growth = [12.5, 15.2, 8.7, 19.3]
profit_margin = [5.3, 6.8, 4.1, 7.2]
error_revenue_growth = [1.2, 1.5, 1.1, 1.8]
error_profit_margin = [0.8, 0.7, 0.6, 0.9]

x = np.arange(len(revenue_growth))  # x-coordinates for the bars
labels = ["Quarterly Revenue Growth", "Profit Margin"]
title = "Financial Performance of Companies"
ylims = [[0, 25], [0, 10]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax1 = plt.subplots(figsize=(10, 6))
# Bar width
width = 0.35

# Plotting 'revenue_growth' on the primary y-axis
bars1 = ax1.bar(
    x - width / 2,
    revenue_growth,
    width,
    label=labels[0],
    color="#4CAF50",  # Green color for growth
    yerr=error_revenue_growth,
    capsize=5,
    edgecolor="black",
)

# Create the secondary y-axis for 'profit_margin'
ax2 = ax1.twinx()
bars2 = ax2.bar(
    x + width / 2,
    profit_margin,
    width,
    label=labels[1],
    color="#2196F3",  # Blue color for stability
    yerr=error_profit_margin,
    capsize=5,
    edgecolor="black",
)

# Adding annotations directly on the bars for clarity
for i, bar in enumerate(bars1):
    height = bar.get_height()
    label_x_pos = bar.get_x() + bar.get_width() / 2
    ax1.text(
        label_x_pos,
        height - error_revenue_growth[i] - 0.5,
        f"{height}%",
        rotation=90,
        ha="center",
        va="bottom" if height < 0 else "top",
    )
for j, bar in enumerate(bars2):
    height = bar.get_height()
    label_x_pos = bar.get_x() + bar.get_width() / 2
    ax2.text(
        label_x_pos,
        height - error_profit_margin[j] - 0.3,
        f"{height}%",
        rotation=90,
        ha="center",
        va="bottom" if height < 0 else "top",
    )

fig.suptitle(title)
# Adding labels, title, and custom x-axis tick labels
ax1.set_ylabel(labels[0], color="#4CAF50")
ax2.set_ylabel(labels[1], color="#2196F3")
ax1.set_xticks(x)
ax1.set_xticklabels(companies)

# Add a horizontal line at y=0 if needed
ax1.axhline(0, color="grey", linewidth=0.8)

# Adjusting y-axis limits to fit the annotations and errors
ax1.set_ylim(ylims[0])
ax2.set_ylim(ylims[1])

# Adding grid lines for better readability
ax1.yaxis.grid(linestyle="--", linewidth="0.5", color="grey")
ax1.set_axisbelow(True)

ax2.yaxis.grid(linestyle="--", color="grey")
ax2.set_axisbelow(True)

# Adding legend
fig.legend(loc="upper center", bbox_to_anchor=(0.5, 1.1), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("errorbar_104.pdf", bbox_inches="tight")
