
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for factors affecting philosophical schools of thought
categories = [
    "Historical Context",
    "Cultural Influence",
    "Technological Advances",
    "Political Environment",
    "Economic Conditions",
    "Religious Influence",
    "Educational Systems",
    "Philosophers' Personal Life",
    "Public Reception",
    "Globalization",
]
values = [0.25, 0.2, 0.15, 0.1, 0.05, -0.1, -0.2, -0.15, -0.05, 0.1]
errors = [0.05, 0.04, 0.03, 0.03, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01]

min_val = min(values) - 0.1
max_val = max(values) + 0.1


# Axes Limits and Labels
title_value = "Factors Affecting Philosophical Schools of Thought"
ylabel_value = "Factors"
xlabel_value = "Impact (Δ to baseline)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(12, 8))
# Normalizing function to convert values to a 0-1 range for color scaling
def normalize(value, min_val, max_val):
    return (value - min_val) / (max_val - min_val)

# Determine color based on normalized value
def get_color(value):
    norm_value = normalize(value, min_val, max_val)
    blue_base = np.array(mcolors.to_rgb("#41729F"))
    # Create a color that ranges from very light blue to the base blue
    return mcolors.to_hex((1 - blue_base) * (1 - norm_value) + blue_base)

colors = [get_color(value) for value in values]

# Horizontal bar chart
bars = ax.barh(
    categories, values, xerr=errors, color=colors, capsize=5, edgecolor="none"
)
ax.set_ylabel(ylabel_value)
ax.set_xlabel(xlabel_value)
ax.set_title(title_value, fontsize=16, weight='bold')

# Set y-axis and x-axis limits
ax.set_xlim(min_val, max_val)  # Adjust limits to encompass errors

# Remove top and right spines for a cleaner look
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Customize grid lines
ax.xaxis.grid(True, linestyle="--", which="major", color="gray", alpha=0.6)
ax.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping of ylabel
plt.tight_layout()
plt.savefig("errorbar_114.pdf", bbox_inches="tight")
