
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Art Gallery Data for three major cities
metrics = ["Gallery Visits", "Art Pieces Sold", "Exhibitions Held"]
values = np.array(
    [
        [300, 130, 45],  # Paris
        [250, 145, 35],  # London
        [200, 120, 40],  # New York
    ]
)

# Asymmetric error values, more proportionate to the data scale
errors = np.array(
    [
        [[30, 25], [15, 10], [5, 5]],  # Errors for Paris (lower, upper)
        [[25, 20], [10, 15], [6, 4]],  # Errors for London
        [[20, 15], [12, 8], [4, 6]],  # Errors for New York
    ]
)

# Creating subplots for each city
cities = ["Paris", "London", "New York"]

ylabel = "Metric Values (Thousands)"
ylim = [0, 350]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(1, 3, figsize=(12, 6))  # Larger and more balanced layout


# Function to plot each city's data
def plot_city_data(ax, errors, city_index, city_name):
    x = np.arange(len(metrics))  # the label locations
    bar_colors = ["#FF6347", "#4682B4", "#32CD32"]
    barerrors = np.array(errors).T[:, :, city_index]
    bars = ax.bar(x, values[city_index], yerr=barerrors, color=bar_colors, capsize=7, edgecolor='gray')
    for bar, lower_error, upper_error in zip(bars, barerrors[0], barerrors[1]):
        # Position for lower error text
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            bar.get_height() - lower_error - 20,
            f"-{lower_error}",
            va="bottom",
            ha="center",
            color="black",
        )
        # Position for upper error text
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            bar.get_height() + upper_error + 5,
            f"+{upper_error}",
            ha="center",
            color="black",
        )

    ax.set_title(city_name)
    ax.set_xticks(x)
    ax.set_xticklabels(metrics, rotation=45)
    ax.set_ylabel(ylabel)
    ax.set_ylim(ylim)  # Uniform scale for all charts


for i, city in enumerate(cities):
    plot_city_data(axs[i], errors, i, city)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_116.pdf", bbox_inches="tight")

