
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data setup
import numpy as np

np.random.seed(0)

# Teams
teams = ["Team A", "Team B", "Team C", "Team D"]
x = np.arange(len(teams))  # X-axis points

# Performance scores for two metrics in different teams
offense_scores = np.array([75, 82, 78, 80])  # Example scores for offensive performance
defense_scores = np.array([68, 75, 70, 72])  # Example scores for defensive performance

# Errors for both metrics
offense_errors = np.array([3, 4, 3, 2])
defense_errors = np.array([4, 3, 4, 3])

labels = ["Offense Performance", "Defense Performance"]
ylabels = ["Offense Score", "Defense Score"]

title = "Team Performance Scores"
ylims = [[60, 90], [60, 90]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting setup
fig, ax1 = plt.subplots(figsize=(8, 5))

# Bar width and hatch patterns
width = 0.35
hatch_patterns = ["//", "oo"]

# Colors for the bars
colors = ["#4CAF50", "#FF9800"]  # Green and Orange

# Plot data on the left y-axis (offense scores)
ax1.bar(
    x,
    offense_scores,
    width,
    color=colors[0],
    hatch=hatch_patterns[0],
    label=labels[0],
    yerr=offense_errors,
    capsize=5,
    edgecolor="black",
)

# Create a second y-axis sharing the same x-axis (defense scores)
ax2 = ax1.twinx()
ax2.bar(
    x + width,
    defense_scores,
    width,
    color=colors[1],
    hatch=hatch_patterns[1],
    label=labels[1],
    yerr=defense_errors,
    capsize=5,
    edgecolor="black",
)

# Set the x-ticks to be in the middle of the two bars and add the labels
ax1.set_xticks(x + width / 2)
ax1.set_xticklabels(teams)

# Add a legend
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Set labels for y-axes
ax1.set_ylabel(ylabels[0], color=colors[0])
ax2.set_ylabel(ylabels[1], color=colors[1])

# Set colors for y-axes
ax1.tick_params(axis="y", colors=colors[0])
ax2.tick_params(axis="y", colors=colors[1])

# Set the limits for y-axes to fit the data
ax1.set_ylim(ylims[0])
ax2.set_ylim(ylims[0])

# Set title for the chart
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_118.pdf", bbox_inches="tight")
