
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
platforms = [
    "Facebook",
    "Twitter",
    "YouTube",
    "Instagram",
    "TikTok",
    "Newspapers",
    "Magazines",
    "TV",
    "Radio",
    "Blogs",
]
log_engagements = [
    -0.45,
    -0.40,
    -0.43,
    -0.50,
    -0.52,
    -0.55,
    -0.57,
    -0.60,
    -0.65,
    -0.75,
]
errors = [0.04, 0.05, 0.04, 0.05, 0.06, 0.05, 0.06, 0.05, 0.07, 0.08]
ylabel = "Log Engagement ↑"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#3b5998",  # Facebook blue
    "#1DA1F2",  # Twitter blue
    "#FF0000",  # YouTube red
    "#C13584",  # Instagram gradient
    "#69C9D0",  # TikTok turquoise
    "#6D6E70",  # Newspapers gray
    "#FF6600",  # Magazines orange
    "#00ADEF",  # TV blue
    "#E52D27",  # Radio red
    "#FC4C02",  # Blogs orange
]

# Plot
fig, ax = plt.subplots(figsize=(10, 6))
bars = ax.bar(
    platforms,
    log_engagements,
    yerr=errors,
    color=colors,
    capsize=5,
    error_kw={
        "ecolor": "darkgray",
    },
)

# Annotate bars with log engagement values
for bar, log_eng, error, platform in zip(bars, log_engagements, errors, platforms):
    ax.text(
        bar.get_x() + bar.get_width() / 2,
        bar.get_height() - error - 0.1,
        f"{log_eng:.2f}",
        ha="center",
        va="bottom",
    )
    # Add platform name on the bar
    ax.text(
        bar.get_x() + bar.get_width() / 2, 0, platform, ha="center", va="top", rotation=90
    )

# Legend
# ax.legend(legendtitle, loc="lower left")
ax.set_xticks([])
plt.tick_params(axis="x", which="both", length=0)
# Labels and grid
ax.set_ylabel(ylabel)
ax.set_ylim(-2.00, 0.00)

ax.yaxis.grid(True)
ax.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to match the original image's dimensions
plt.tight_layout()
plt.savefig("errorbar_31.pdf", bbox_inches="tight")
