
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
judges = ["Cardiologists", "Oncologists", "Neurologists", "General Practitioners"]
protocols = [
    "Medication",
    "Surgery",
    "Therapy",
    "Rehabilitation",
    "Preventive Care",
    "Emergency Care",
]
accuracy_means = np.array(
    [
        [92, 70, 60, 80, 85, 90],  # Cardiologists
        [90, 75, 65, 82, 83, 88],  # Oncologists
        [85, 60, 70, 78, 88, 92],  # Neurologists
        [88, 72, 68, 84, 81, 86],  # General Practitioners
    ]
)
accuracy_std = np.array(
    [
        [3, 4, 5, 4, 5, 6],  # Cardiologists
        [4, 3, 5, 4, 6, 5],  # Oncologists
        [5, 4, 6, 5, 4, 3],  # Neurologists
        [4, 5, 4, 3, 4, 5],  # General Practitioners
    ]
)
legendtitle = "Treatment"
xlabel = "Expert Group"
ylabel = "Treatment Effectiveness (%)"
ylim = [0, 100]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(12, 8))

# colors (Health-themed colors)
colors = [
    "#add8e6",  # Light blue
    "#90ee90",  # Light green
    "#ffcccb",  # Light red
    "#ffd700",  # Gold
    "#dda0dd",  # Plum
    "#fa8072",  # Salmon
]

# Bar width
bar_width = 0.15
bar_width_expert = 0.75

# Set position of bar on X axis
r = np.arange(len(judges))

# Draw bars for 'Medication' protocol
i = protocols.index("Medication")
ax.bar(
    r + (i + 3) * bar_width,
    accuracy_means[:, i],
    yerr=accuracy_std[:, i],
    width=bar_width_expert,
    label=protocols[i],
    capsize=5,
    color=colors[i],
    hatch="//",
    edgecolor="black",
)

# Draw bars for other protocols
for i in range(len(protocols)):
    if protocols[i] == "Medication":
        continue
    ax.bar(
        r + i * bar_width,
        accuracy_means[:, i],
        yerr=accuracy_std[:, i],
        width=bar_width,
        label=protocols[i],
        capsize=5,
        color=colors[i],
        edgecolor="black",
    )

# Add xticks on the middle of the group bars
ax.set_xlabel(xlabel)
ax.set_xticks(r + bar_width * (len(protocols) - 1) / 2)
ax.set_xticklabels(judges)

# Create legend & Show graphic
handles, labels = ax.get_legend_handles_labels()
order = [0, 1, 2, 4, 3, 5]  # Reordering the legend
ax.legend(
    [handles[idx] for idx in order],
    [labels[idx] for idx in order],
    loc="upper center",
    bbox_to_anchor=(0.5, 1.15),
    ncol=3,
    title=legendtitle,
)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)  # Adjust y-axis limit to accommodate error bars

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_36.pdf", bbox_inches="tight")
