
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data (replace with actual values)
groups = [
    "ToolA / v1.0 / Expert",
    "ToolA / v1.0 / Intermediate",
    "ToolA / v1.0 / Beginner",
    "ToolA / v2.0 / Expert",
    "ToolA / v2.0 / Intermediate",
    "ToolA / v2.0 / Beginner",
    "ToolB / v1.0 / Expert",
    "ToolB / v1.0 / Intermediate",
    "ToolB / v1.0 / Beginner",
    "ToolB / v2.0 / Expert",
    "ToolB / v2.0 / Intermediate",
    "ToolB / v2.0 / Beginner",
    "ToolC / v1.0 / Expert",
    "ToolC / v1.0 / Intermediate",
    "ToolC / v1.0 / Beginner",
    "ToolC / v2.0 / Expert",
    "ToolC / v2.0 / Intermediate",
    "ToolC / v2.0 / Beginner",
]
solid_bar_values = np.random.rand(18) * 100  # Efficiency Score
striped_bar_values = np.random.rand(18) * 100  # Satisfaction Score
error = np.random.rand(18) * 5  # Error margins

# Labels and Plot Types
label_Striped = "Satisfaction"
label_Solid = "Efficiency"

# Axes Limits and Labels
xlabel_value = "Score"
ylabel_value = "Design Tool / Version / User Expertise"
title = "Design Tool Performance Metrics"
ylim_values = [-0.5, 17.5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(12, 10))

# Create grouped bar chart with error bars
bar_width = 0.4
index = np.arange(len(groups))
plt.barh(
    index - 0.2,
    striped_bar_values,
    bar_width,
    color="#8ecae6",
    hatch="..",
    xerr=error,
    label=label_Striped,
    capsize=3,
    edgecolor="black",
    alpha=0.8,
)
plt.barh(
    index + 0.2,
    solid_bar_values,
    bar_width,
    color="#fb8500",
    hatch="xx",
    xerr=error,
    label=label_Solid,
    capsize=3,
    edgecolor="black",
    alpha=0.8,
)

# Add labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title)
plt.yticks(index, groups, rotation=0)
plt.gca().set_ylim(ylim_values)
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_37.pdf", bbox_inches="tight")
