
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)  # For reproducibility 

# Data
modes_of_transport = ["Car", "Bus", "Train", "Bicycle", "Walking"]
travel_time_means = [30, 45, 20, 50, 60]
travel_time_errors = [5, 7, 3, 6, 8]
fuel_consumption_means = [8, 6, 3, 0, 0]  # in liters per 100km or equivalent
fuel_consumption_errors = [1, 1.5, 0.5, 0, 0]

ylabel1 = "Average Travel Time (minutes)"
xlabel1 = "(a) Travel Time for Different Modes of Transport"
ylabel2 = "Fuel Consumption (liters/100 km)"
xlabel2 = "(b) Fuel Consumption for Different Modes of Transport"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))  # Adjusted for better dimensions
colors = ["#4e79a7", "#f28e2b", "#e15759", "#76b7b2", "#59a14f"]

# Travel time for different modes of transport
ax1.bar(modes_of_transport, travel_time_means, yerr=travel_time_errors, color=colors, capsize=5)
ax1.set_ylabel(ylabel1)
ax1.set_xlabel(xlabel1)
for i, v in enumerate(travel_time_means):
    ax1.text(i, v + travel_time_errors[i] + 2, str(v), ha="center", va="bottom")
ax1.spines["top"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.yaxis.grid(True)
ax1.set_axisbelow(True)

# Fuel consumption for different modes of transport
ax2.bar(modes_of_transport, fuel_consumption_means, yerr=fuel_consumption_errors, color=colors, capsize=5)
ax2.set_ylabel(ylabel2)
ax2.set_xlabel(xlabel2)
for i, v in enumerate(fuel_consumption_means):
    ax2.text(i, v + fuel_consumption_errors[i] + 0.2, str(v), ha="center", va="bottom")

ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.yaxis.grid(True)
ax2.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("errorbar_41.pdf", bbox_inches="tight")
