
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Data
professions = ["Engineer", "Doctor", "Artist", "Teacher", "Lawyer"]
average_age = [34.5, 42.3, 36.8, 39.4, 41.1]
age_errors = [3.2, 2.4, 4.1, 3.6, 2.9]
average_income = [70000, 120000, 50000, 60000, 110000]
income_errors = [5000, 10000, 4000, 3000, 8000]

ylabel1 = "Average Age (Years)"
xlabel1 = "(a) Average Age of Professions"
ylabel2 = "Average Income (USD)"
xlabel2 = "(b) Average Income of Professions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 4))

colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0"]

# Average age of professions
ax1.bar(professions, average_age, yerr=age_errors, color=colors, capsize=5)
ax1.set_ylabel(ylabel1)
ax1.set_xlabel(xlabel1)
for i, v in enumerate(average_age):
    ax1.text(i, v + age_errors[i] + 1, str(v), ha="center", va="bottom")
ax1.spines["top"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.yaxis.grid(True)
ax1.set_axisbelow(True)

# Average income of professions
ax2.bar(professions, average_income, yerr=income_errors, color=colors, capsize=5)
ax2.set_ylabel(ylabel2)
ax2.set_xlabel(xlabel2)
for i, v in enumerate(average_income):
    ax2.text(i, v + income_errors[i] + 2000, str(v), ha="center", va="bottom")
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.yaxis.grid(True)
ax2.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("errorbar_42.pdf", bbox_inches="tight")
