
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# New data for plotting - Average Book Ratings vs. Training Data Size
sizes = ["5%", "10%", "20%", "30%", "40%", "50%"]
samples = [
    "(40 reviews)",
    "(81 reviews)",
    "(163 reviews)",
    "(245 reviews)",
    "(326 reviews)",
    "(408 reviews)",
]
x = range(len(sizes))
# Hypothetical average ratings for each dataset size
y = [65.5, 67.0, 68.7, 69.8, 70.5, 71.2]
# Hypothetical errors for each measurement
errors = [2.0, 1.8, 1.5, 1.3, 1.1, 1.0]
ylabel = "Average Rating (%)"
xlabel = "Percent of Review Data Used for Training\n(Number of Reviews)"
title = "Average Book Ratings vs. Training Data Size"
ylim = [60, 75]
yticks = [60, 65, 70, 75]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the bar chart
plt.figure(
    figsize=(10, 7)
)  # Adjusting figure size to match original image's dimensions
# Applying a new color scheme
bars = plt.bar(x, y, yerr=errors, color="#8B4513", capsize=5, edgecolor='brown', hatch='/')

# Adding data labels on top of the bars
for bar in bars:
    yval = bar.get_height()
    plt.text(
        bar.get_x() + bar.get_width() / 2,
        yval + 0.5,
        round(yval, 1),
        ha="center",
        va="bottom",
        fontsize=10,
        fontweight='bold'
    )

# Setting the x-axis labels with both percentages and sample sizes
plt.xticks(x, [f"{size}\n{sample}" for size, sample in zip(sizes, samples)])

# Setting the y-axis label
plt.ylabel(ylabel, fontsize=12, fontweight='bold')

# Setting the title of the chart
plt.xlabel(xlabel, fontsize=12, fontweight='bold')

# Setting the chart title
plt.title(title, fontsize=14, fontweight='bold', pad=20)

# Adjusting y-axis range
plt.ylim(ylim)
plt.yticks(yticks)
# Adding grid to the background
plt.grid(axis="both", alpha=0.3, which="both", color="gray", linestyle='--', linewidth=0.5)

# Making the axis lines visible
plt.gca().spines["top"].set_visible(True)
plt.gca().spines["right"].set_visible(True)
plt.gca().spines["bottom"].set_visible(True)
plt.gca().spines["left"].set_visible(True)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_43.pdf", bbox_inches="tight")
