
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
sizes = ["10%", "20%", "30%", "40%", "50%", "60%"]
samples = [
    "(50 cases)",
    "(100 cases)",
    "(150 cases)",
    "(200 cases)",
    "(250 cases)",
    "(300 cases)",
]
x = range(len(sizes))
y = [70.5, 72.1, 73.8, 75.2, 76.0, 77.3]
errors = [2.0, 1.8, 1.5, 1.2, 1.0, 0.9]
ylabel = "Cases Solved (%)"
xlabel = "Level of AI Assistance"
ylim = [65, 80]
yticks = [65, 68, 70, 72, 74, 76, 78]
title = "Impact of AI Assistance on Case Solving Rate"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the bar chart
plt.figure(figsize=(10, 7))
bars = plt.bar(x, y, yerr=errors, color="#4682B4", edgecolor="#2F4F4F", capsize=5)

# Adding data labels on top of the bars
for bar in bars:
    yval = bar.get_height()
    plt.text(
        bar.get_x() + bar.get_width() / 2,
        yval + 0.5,
        round(yval, 2),
        ha="center",
        va="bottom",
        color="#2F4F4F"
    )

# Setting the x-axis labels with both percentages and sample sizes
plt.xticks(x, [f"{size}\n{sample}" for size, sample in zip(sizes, samples)], fontweight="bold")

# Setting the y-axis label and title
plt.ylabel(ylabel, fontsize=12, fontweight="bold")
plt.xlabel(xlabel, fontsize=12, fontweight="bold")
plt.title(title, fontsize=14, fontweight="bold")

# Adjusting y-axis range
plt.ylim(ylim)
plt.yticks(yticks, fontsize=11)
# Adding grid to the background
plt.grid(axis="y", alpha=0.7, which="both", linestyle="--", linewidth=0.7, color="gray")

# Making the axis lines more visible
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_color("#2F4F4F")
plt.gca().spines["left"].set_color("#2F4F4F")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_44.pdf", bbox_inches="tight")
