
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the left plot (Average Temperature by Region)
left_categories = [
    "North America",
    "South America",
    "Europe",
    "Africa",
    "Asia",
    "Australia",
    "Antarctica",
]
left_means = [15.5, 22.3, 10.8, 25.4, 17.5, 20.6, -30.0]  # Average temperatures in °C
left_errors = [1.2, 0.8, 1.1, 1.5, 0.9, 1.0, 0.5]

# Data for the right plot (Average Rainfall by Region)
right_categories = [
    "North America",
    "South America",
    "Europe",
    "Africa",
    "Asia",
    "Australia",
    "Antarctica",
]
right_means = [900, 1600, 800, 1100, 1200, 600, 50]  # Average annual rainfall in mm
right_errors = [50, 70, 60, 90, 80, 40, 10]

# Chart Labels
title1 = "Average Temperature by Region (°C)"
ylabel1 = "Temperature (°C)"
ylim1 = [-40, 30]
yticks1 = np.arange(-30, 31, 10)
title2 = "Average Annual Rainfall by Region (mm)"
ylabel2 = "Rainfall (mm)"
ylim2 = [0, 2000]
yticks2 = np.arange(0, 2001, 400)
suptitle = "Geographic Data Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Left plot (Average Temperature)
ax1.bar(
    left_categories,
    left_means,
    yerr=left_errors,
    color=["#FF5733", "#FF8D1A", "#FFB100", "#FFD700", "#FFE700", "#FFF700", "#B0E57C"],
    capsize=5,
    error_kw=dict(ecolor="black", lw=1.5, capsize=5, capthick=2),
)
ax1.set_title(title1)
ax1.set_ylabel(ylabel1)
ax1.set_ylim(ylim1)
ax1.set_yticks(yticks1)
ax1.set_xticklabels(left_categories, rotation=45, ha="right")
ax1.tick_params(axis="both", length=4)
ax1.grid(True, linestyle='--', alpha=0.6)
ax1.set_axisbelow(True)
for spine in ax1.spines.values():
    spine.set_color("gray")

# Right plot (Average Annual Rainfall)
ax2.bar(
    right_categories,
    right_means,
    yerr=right_errors,
    color=["#1E90FF", "#00BFFF", "#00CED1", "#20B2AA", "#48D1CC", "#40E0D0", "#5F9EA0"],
    capsize=5,
    error_kw=dict(ecolor="black", lw=1.5, capsize=5, capthick=2),
)
ax2.set_title(title2)
ax2.set_ylabel(ylabel2)
ax2.set_ylim(ylim2)
ax2.set_yticks(yticks2)
ax2.set_xticklabels(right_categories, rotation=45, ha="right")
ax2.tick_params(axis="both", length=4)
ax2.grid(True, linestyle='--', alpha=0.6)
ax2.set_axisbelow(True)

# Set the title for the entire figure
fig.suptitle(suptitle, fontsize=16)

for spine in ax2.spines.values():
    spine.set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("errorbar_48.pdf", bbox_inches="tight")
