
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
teams = [
    "Team A",
    "Team B",
    "Team C",
    "Team D",
    "Team E",
]
scores = [75, 85, 90, 70, 60]
variability = [10, 8, 7, 12, 15]
xlabel = "Average Performance Score"
title = "Season Performance of Sports Teams"
label = "Top Performer Threshold (85)"
xvline = 85

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the bar chart
plt.figure(figsize=(12, 8))  # Adjusting figure size to accommodate new data
bar_colors = ["#1f77b4", "#2ca02c", "#d62728", "#ff7f0e", "#9467bd"]
plt.barh(teams, scores, xerr=variability, color=bar_colors, capsize=7)
plt.xlabel(xlabel, fontsize=14)
plt.title(title, fontsize=16)
plt.gca().tick_params(axis="both", length=0)  # Hide tick marks

# Adding the vertical line
plt.axvline(x=xvline, color="red", linestyle="--", linewidth=2, label=label)
plt.gca().grid(visible=True, color="gray", alpha=0.5, linestyle="dotted", linewidth=0.75)

# Adding the legend
plt.legend(fontsize=12)

# Removing default spines for a cleaner look
for spine in plt.gca().spines.values():
    spine.set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorbar_51.pdf", bbox_inches="tight")
