
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for Economic Analysis
np.random.seed(0)

countries = [
    "USA",
    "China",
    "Germany",
    "India",
    "UK",
    "France",
    "Brazil",
    "Canada",
    "Japan",
]
gdp_growth = [2.3, 6.0, 1.5, 7.0, 1.8, 1.7, 2.1, 1.4, 0.6]
employment_growth = [1.2, 4.5, 1.0, 2.9, 1.3, 1.1, 1.8, 1.0, 0.3]
error = [0.5, 1.0, 0.4, 1.2, 0.6, 0.5, 0.7, 0.4, 0.2]
labels = ["GDP Growth Rate (%)", "Employment Growth Rate (%)"]
ylabel = "Growth Rate (%)"
ylim = [0, 10]
yticks = np.arange(0, 11, 1)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.subplots(figsize=(12, 5))
# Bar width
bar_width = 0.35

# X position of bars
r1 = np.arange(len(gdp_growth))
r2 = [x + bar_width for x in r1]

# Create bars
plt.bar(
    r1,
    gdp_growth,
    color="#4caf50",
    width=bar_width,
    label=labels[0],
    yerr=error,
    capsize=7,
)
plt.bar(
    r2,
    employment_growth,
    color="#2196f3",
    width=bar_width,
    label=labels[1],
    yerr=error,
    capsize=7,
)

# Add xticks on the middle of the group bars
plt.xticks([r + bar_width / 2 for r in range(len(gdp_growth))], countries)

# Create legend & Show graphic
plt.ylabel(ylabel)
plt.legend(frameon=False, loc="upper left")  # Remove legend background

# Set background color and grid
plt.gca().set_facecolor("#f0f0f0")
plt.grid(color="white", linestyle="-", linewidth=0.5, axis="both")
plt.gca().set_axisbelow(True)

# Set y-axis limits
plt.ylim(ylim)
plt.yticks(yticks)

for spine in plt.gca().spines.values():
    spine.set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_52.pdf", bbox_inches="tight")
