
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data (fictional data for illustration)
import numpy as np

np.random.seed(0)

energy_sources = [
    "Solar",
    "Wind",
    "Hydro",
    "Geothermal",
    "Biomass",
    "Tidal",
    "Wave",
    "Nuclear",
    "Hydrogen",
]
energy_produced = [2000, 2500, 3000, 1500, 1800, 900, 800, 3500, 1200]
forecasted_energy = [1800, 2400, 2800, 1400, 1600, 850, 750, 3400, 1100]
error = [200, 250, 300, 150, 180, 90, 80, 350, 120]
labels = ["Energy Produced", "Forecasted Energy"]
ylabel = "Energy (MWh)"
ylim = [0, 4000]
yticks = np.arange(0, 4001, 500)

# Text labels for the chart
xlabel = "Energy Sources"
title = "Energy Production vs Forecasted Energy"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.subplots(figsize=(12, 6))
# Bar width
bar_width = 0.35

# X position of bars
r1 = np.arange(len(energy_produced))
r2 = [x + bar_width for x in r1]

# Create bars
plt.bar(
    r1,
    energy_produced,
    color="#8CC084",
    width=bar_width,
    label=labels[0],
    yerr=error,
    capsize=7,
)
plt.bar(
    r2,
    forecasted_energy,
    color="#58A6FF",
    width=bar_width,
    label=labels[1],
    yerr=error,
    capsize=7,
)

# Add xticks on the middle of the group bars
plt.xticks([r + bar_width / 2 for r in range(len(energy_produced))], energy_sources)

# Create legend & Show graphic
plt.ylabel(ylabel)
plt.xlabel(xlabel)
plt.title(title)
plt.legend(frameon=False, loc="upper left")  # Remove legend background

# Set background color and grid
plt.gca().set_facecolor("#F5F5F5")
plt.grid(color="white", linestyle="-", linewidth=0.5, axis="both")
plt.gca().set_axisbelow(True)

# Set y-axis limits
plt.ylim(ylim)
plt.yticks(yticks)

# Remove chart spines
for spine in plt.gca().spines.values():
    spine.set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_53.pdf", bbox_inches="tight")
