
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Categories and values (weather data for a specific month)
categories = [
    "Average Temperature (°C)",
    "Total Rainfall (mm)",
    "Average Humidity (%)",
    "Average Wind Speed (km/h)",
    "Sunshine Hours",
    "Max Temperature (°C)",
    "Min Temperature (°C)",
][::-1]
values = [25, 150, 60, 10, 210, 30, 15][::-1]
error = [1, 20, 5, 1.5, 10, 1, 1.2]

# Labels and title
xlabel = "Measurements"
ylabel = "Weather Parameters"
title = "Average Weather Data for July"
xlim = [0, 160]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
fig, ax = plt.subplots(figsize=(10, 8))  # Adjust figure size
bars = ax.barh(
    categories,
    values,
    color=["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2"],
    edgecolor="white",
    height=0.5,
    xerr=error,
    capsize=5,
)

# Set labels and title (if any)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Invert y-axis to match the image
ax.invert_yaxis()

# Set x-axis range to match the reference image
ax.set_xlim(xlim)

# Remove grid lines and make spines less visible
ax.xaxis.grid(False)
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# Set background color to white
ax.set_facecolor("white")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_55.pdf", bbox_inches="tight")

