
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Categories and values for the domain of Education
categories = [
    "Online Learning Platforms",
    "STEM Programs",
    "Humanities Studies",
    "Arts Education",
    "Special Education",
    "Physical Education",
    "Vocational Training",
][::-1]
values = [4.0, 3.8, 3.6, 3.5, 3.45, 3.3, 3.0][::-1]
error = [0.2, 0.3, 0.25, 0.2, 0.15, 0.1, 0.1]
xlabel = "Average Satisfaction Score (out of 5)"
ylabel = "Categories"
title = "Satisfaction Scores in Various Educational Domains"
xlim = [2.5, 5.0]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
fig, ax = plt.subplots(figsize=(10, 6))  # Adjust figure size
bars = ax.barh(
    categories,
    values,
    color="#72A0C1",      # Soft blue color
    edgecolor="black",
    height=0.5,
    xerr=error,
    capsize=5,            # Adding capsize for better error visualization
)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Invert y-axis to match the image
ax.invert_yaxis()

# Set x-axis range to match the reference image
ax.set_xlim(xlim)

# Remove grid lines
ax.xaxis.grid(False)
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)

# Set background color to white
ax.set_facecolor("white")

# Additional stylistic adjustments
for bar in bars:
    bar.set_edgecolor("black")
    bar.set_linewidth(1.5)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_56.pdf", bbox_inches="tight")
