
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
years = [2018, 2019, 2020, 2021]
baseline = [10] * len(years)
method_a = [8.5, 7.8, 7.1, 6.5]
method_b = [9.0, 8.2, 7.4, 6.7]
errors = [0.5, 0.4, 0.3, 0.2]

# Labels and Plot Types
label1 = "Method A"
label2 = "Method B"
label3 = "Baseline"

# Axes Limits and Labels
xlabel_value = "Year"
ylabel_value = "Energy Consumption Reduction (%)"
title = "Energy Efficiency Improvement Over Years"
xticklabels = ["2018", "2019", "2020", "2021"]
ylim_values = [5, 11]
yticks_values = np.arange(5, 12, 1)
legend_title = "Methods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted for the given dimensions
bar_width = 0.35
opacity = 0.8

bar1 = ax.bar(
    np.array(years) - bar_width / 2,
    method_a,
    bar_width,
    alpha=opacity,
    color="#76c7c0",
    label=label1,
    yerr=errors,
    capsize=5,
)

bar2 = ax.bar(
    np.array(years) + bar_width / 2,
    method_b,
    bar_width,
    alpha=opacity,
    color="#ffcc5c",
    label=label2,
    yerr=errors,
    capsize=5,
)

ax.plot(
    years,
    baseline,
    linestyle="--",
    color="#d9534f",
    linewidth=2,
    marker='o',
    markersize=8,
    label=label3,
)

ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(years)
ax.set_xticklabels(xticklabels)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.legend(loc="upper right", title=legend_title)

# Additional aesthetic adjustments
ax.grid(True, linestyle='--', alpha=0.6)
plt.xticks(rotation=45)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_58.pdf", bbox_inches="tight")
