
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
algorithm_version = [1, 2, 3, 4]
baseline = [120] * len(algorithm_version)
algo_v1 = [115, 110, 105, 100]
algo_v2 = [118, 113, 108, 103]
errors = [5, 4, 3, 2]

# Labels and Plot Types
label1 = "Algorithm V1"
label2 = "Algorithm V2"
label3 = "Baseline"

# Axes Limits and Labels
xlabel_value = "Algorithm Version"
ylabel_value = "Average Execution Time (ms)"
title = "Algorithm Efficiency"
xticklabels = ["V1", "V2", "V3", "V4"]
ylim_values = [95, 125]
yticks_values = np.arange(95, 130, 5)
legend_title = "Versions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusted for the given dimensions
bar_width = 0.4
opacity = 0.8

bar1 = ax.bar(
    np.array(algorithm_version) - bar_width / 2,
    algo_v1,
    bar_width,
    alpha=opacity,
    color="#ff9999",
    label=label1,
    yerr=errors,
    capsize=5,
)

bar2 = ax.bar(
    np.array(algorithm_version) + bar_width / 2,
    algo_v2,
    bar_width,
    alpha=opacity,
    color="#66b3ff",
    label=label2,
    yerr=errors,
    capsize=5,
)

ax.plot(
    algorithm_version,
    baseline,
    linestyle="--",
    color="#ffcc99",
    linewidth=2,
    label=label3,
)

ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(algorithm_version)
ax.set_xticklabels(xticklabels)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.legend(loc="upper right", title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_60.pdf", bbox_inches="tight")
