
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data
genres = ["Fiction", "Non-Fiction", "Poetry"]
standard1 = [0.85, 0.77, 0.67]
standard2 = [0.80, 0.75, 0.65]
standard3 = [0.82, 0.76, 0.66]
error = [0.04, 0.03, 0.05]

# Bar positions
x = np.arange(len(genres))
width = 0.25
labels = ["Standard 1", "Standard 2", "Standard 3"]
ylabel = "Readability Score"
title = "Readability Score by Genre and Standard"
xticks = genres
yticks = np.arange(0.5, 0.95, 0.05)
ylim = [0.5, 0.95]
legend_location = "upper center"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))
bars1 = ax.bar(
    x - width,
    standard1,
    width,
    label=labels[0],
    color="#8FBC8F",  # Dark Sea Green
    hatch="\\\\",
    yerr=error,
    capsize=5,
    error_kw=dict(ecolor="black"),
)
bars2 = ax.bar(
    x,
    standard2,
    width,
    label=labels[1],
    color="#20B2AA",  # Light Sea Green
    hatch="--",
    yerr=error,
    capsize=5,
    error_kw=dict(ecolor="black"),
)
bars3 = ax.bar(
    x + width,
    standard3,
    width,
    label=labels[2],
    color="#DEB887",  # Burly Wood
    hatch="xx",
    yerr=error,
    capsize=5,
    error_kw=dict(ecolor="black"),
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(xticks)
ax.set_yticks(yticks)
ax.set_ylim(ylim)  # Adjust y-axis scale
ax.legend(loc=legend_location, ncol=3)  # Move legend to upper center


# Adding the data labels on the bars
def add_labels(bars):
    for bar in bars:
        height = bar.get_height()
        ax.annotate(
            "{}".format(round(height, 3)),
            xy=(
                bar.get_x() + bar.get_width() / 2,
                height + error[bars.index(bar)],
            ),  # Adjust label position to be above error bars
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )


add_labels(bars1)
add_labels(bars2)
add_labels(bars3)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_62.pdf", bbox_inches="tight")
