
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "Fossil Fuels",
    "Hydro",
    "Wind",
    "Solar",
][::-1]

subcategories = ["CO2 Reduction", "Cost", "Efficiency", "Output"][::-1]

values = [
    [0.30, 0.45, 0.55, 0.70],  # Fossil Fuels
    [0.50, 0.60, 0.75, 0.80],  # Hydro
    [0.60, 0.65, 0.80, 0.85],  # Wind
    [0.70, 0.70, 0.85, 0.90],  # Solar
]

errors = [
    [0.05, 0.04, 0.03, 0.02],
    [0.04, 0.03, 0.02, 0.01],
    [0.03, 0.02, 0.02, 0.01],
    [0.02, 0.01, 0.01, 0.01],
]

percentages = [
    "+3.0%", "+4.5%", "+5.5%", "+7.0%",
    "+5.0%", "+6.0%", "+7.5%", "+8.0%",
    "+6.0%", "+6.5%", "+8.0%", "+8.5%",
    "+7.0%", "+7.0%", "+8.5%", "+9.0%",
][::-1]

xlim = [0.2, 1.0]

# Labels
xlabel = "Metric Value"
fig_title = "Energy Source Metrics Analysis"
subtitle = "Comparison of various energy sources"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axes = plt.subplots(4, 1, figsize=(10, 12), sharex=True)
# Colors
colors = ["#F08080", "#87CEEB", "#98FB98", "#FFD700"]

for i, ax in enumerate(axes):
    ax.barh(subcategories, values[i][::-1], xerr=errors[i], color=colors[i], capsize=5, edgecolor='black')
    ax.set_yticklabels(subcategories)
    ax.set_xlim(xlim)
    ax.set_ylabel(categories[i], fontsize=12, fontweight='bold')
    for j, v in enumerate(values[i][::-1]):
        ax.text(v + errors[i][j] + 0.02, j, percentages[i * 4 + j], color="black", va="center", fontsize=10, fontweight='bold')

# X-axis label and title
plt.xlabel(xlabel, fontsize=12, fontweight='bold')
plt.suptitle(fig_title, fontsize=16, fontweight='bold')
plt.title(subtitle, fontsize=12, fontweight='regular')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("errorbar_67.pdf", bbox_inches="tight")
