
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data
categories = ["Spring", "Summer", "Winter"]
methods = ["Model A", "Model B", "Model C", "Model D"]
performance = np.array([[78, 82, 85, 80], [88, 85, 90, 87], [70, 75, 72, 78]])
errors = np.array([[5, 7, 6, 5], [4, 6, 5, 4], [8, 7, 6, 7]])
ylim = [60, 95]
ylabel = "Forecasting Accuracy (%)"
xlabel = "Seasons"
legend_labels = methods

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure size 720x216 pixels
fig, axes = plt.subplots(1, 3, figsize=(10, 3))
# Colors
colors = ["#1f77b4", "#2ca02c", "#ff7f0e", "#d62728"]

# Bar width
bar_width = 1

# Plotting bars
for i, ax in enumerate(axes):
    for j, method in enumerate(methods):
        ax.bar(
            j + bar_width * i,
            performance[i, j],
            width=bar_width,
            color=colors[j],
            alpha=0.7,
            yerr=errors[i, j],
            capsize=5,
            label=method if i == 0 else "",
        )

# Setting x-axis labels, y-axis limits, and titles
for i, ax in enumerate(axes):
    ax.set_xticks([])
    ax.set_ylim(ylim)
    ax.set_xlabel(f"({chr(97+i)}) {categories[i]}")
    ax.set_ylabel(ylabel if i == 0 else "")
    ax.yaxis.grid(True, linestyle='--', linewidth=0.7)
    ax.set_axisbelow(True)

# Adding legend outside of the plot
fig.legend(legend_labels, loc="upper center", bbox_to_anchor=(0.5, 1.1), ncol=len(methods))

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout and saving the figure
plt.tight_layout()
plt.savefig("errorbar_73.pdf", bbox_inches="tight")
