
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data
categories = ["Cardio", "Strength Training", "Flexibility"]
methods = ["Running", "Weightlifting", "Yoga", "Swimming"]
performance = np.array([[75, 60, 50, 65], [80, 85, 45, 55], [50, 65, 80, 70]])
errors = np.array([[5, 10, 8, 7], [6, 5, 7, 6], [10, 9, 5, 4]])
ylim = [30, 90]
ylabel = "Average Improvement in Health Score"
xlabel_template = "(a) {}"
legendlabels = methods

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure size 720x216 pixels
fig, axes = plt.subplots(1, 3, figsize=(10, 3))
# Optimize colors
colors = ["#2a9d8f", "#e76f51", "#f4a261", "#264653"]

# Bar width
bar_width = 0.8

# Plotting bars
for i, ax in enumerate(axes):
    for j, method in enumerate(methods):
        ax.bar(
            j + bar_width * i,
            performance[i, j],
            width=bar_width,
            color=colors[j],
            yerr=errors[i, j],
            capsize=5,
            label=method if i == 0 else "",
        )

# Setting x-axis labels, y-axis limits, and titles
for i, ax in enumerate(axes):
    ax.set_xticks([])
    ax.set_ylim(ylim)
    ax.set_xlabel(f"({chr(97 + i)}) {categories[i]}")
    ax.set_ylabel(ylabel)
    ax.yaxis.grid(True)
    ax.set_axisbelow(True)

# Adding legend outside of the plot
fig.legend(loc="upper center", bbox_to_anchor=(0.5, 1.1), ncol=len(methods))

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout and saving the figure
plt.tight_layout()
plt.savefig("errorbar_75.pdf", bbox_inches="tight")
