
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data (replace with actual values)
groups = [
    "Tech / Q1",
    "Tech / Q2",
    "Tech / Q3",
    "Tech / Q4",
    "Health / Q1",
    "Health / Q2",
    "Health / Q3",
    "Health / Q4",
    "Finance / Q1",
    "Finance / Q2",
    "Finance / Q3",
    "Finance / Q4",
    "Energy / Q1",
    "Energy / Q2",
]
solid_bar_values = np.random.rand(14) * 0.4 + 0.2  # Ensure values are between 0.2 and 0.6
striped_bar_values = np.random.rand(14) * 0.3 + 0.1  # Ensure values are between 0.1 and 0.4
error = np.random.rand(14) * 0.1 + 0.01
labels = ["Positive Growth", "Negative Growth"]
xlabel = "Performance Metrics"
ylabel = "Stock Sectors and Quarters"
title = "Stock Market Performance"
xlim = [0, 1.1]
ylim = [-0.4, 13.4]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 8))

# Create grouped bar chart with error bars
bar_width = 0.8
index = np.arange(len(groups))

# Solid bars
plt.barh(
    index,
    solid_bar_values,
    bar_width,
    color="#66c2a5",
    xerr=error,
    label=labels[0],
    capsize=5,
    edgecolor="black",
)

# Striped bars (negative growth)
plt.barh(
    index,
    striped_bar_values,
    bar_width,
    left=solid_bar_values,
    color="#8da0cb",
    xerr=error,
    label=labels[1],
    capsize=5,
    edgecolor="black",
)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.yticks(index, groups, rotation=0)
plt.gca().set_xlim(xlim)
plt.gca().set_ylim(ylim)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_77.pdf", bbox_inches="tight")
