
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Regions for philosophical influence
regions = ["Europe", "Asia", "North America", "South America", "Africa"]

# Influence of Different Philosophical Schools (% of respondents feeling influenced, hypothetical data)
philosophical_influence = [45, 30, 35, 25, 20]
philosophical_influence_errors = [5, 6, 5, 4, 3]

# Number of Published Philosophical Papers (in hundreds, hypothetical data)
philosophical_papers = [120, 80, 95, 60, 50]
philosophical_papers_errors = [10, 15, 12, 8, 5]

# Interest in Philosophy (number of philosophy courses offered, hypothetical data)
philosophical_interest = [35, 25, 30, 20, 15]
philosophical_interest_errors = [4, 5, 3, 2, 2]

titles = [
    "Influence of Philosophical Schools",
    "Published Philosophical Papers",
    "Interest in Philosophy",
]
xlabels = ["% of Respondents", "Number of Papers (in hundreds)", "Number of Courses"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a subplot for each category
fig, (ax1, ax2, ax3) = plt.subplots(3, 1, figsize=(6, 9))
# Elegant color scheme for philosophy-themed charts
colors = ['#8E7CC3', '#D4A6C8', '#F7CAC9', '#92A8D1', '#034F84']

def add_bars_with_annotations(ax, data, errors, colors):
    bars = ax.barh(regions, data, xerr=errors, color=colors, capsize=0)
    for i, bar in enumerate(bars):
        width = bar.get_width()
        label_x_pos = bar.get_width() + errors[i] * 0.2
        ax.text(
            label_x_pos, bar.get_y() + bar.get_height() / 2, f"{width}", va="bottom"
        )

# Plot Influence of Different Philosophical Schools on the first subplot
ax1.barh(
    regions,
    philosophical_influence,
    xerr=philosophical_influence_errors,
    edgecolor="black",
    color=colors,
    capsize=0,
)
add_bars_with_annotations(ax1, philosophical_influence, philosophical_influence_errors, colors)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.xaxis.grid(True, linestyle="--")
ax1.spines["right"].set_visible(False)
ax1.spines["top"].set_visible(False)

# Plot Number of Published Philosophical Papers on the second subplot
ax2.barh(
    regions,
    philosophical_papers,
    xerr=philosophical_papers_errors,
    edgecolor="black",
    color=colors,
    capsize=0,
)
add_bars_with_annotations(ax2, philosophical_papers, philosophical_papers_errors, colors)
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.xaxis.grid(True, linestyle="--")
ax2.spines["right"].set_visible(False)
ax2.spines["top"].set_visible(False)

# Plot Interest in Philosophy on the third subplot
ax3.barh(
    regions,
    philosophical_interest,
    xerr=philosophical_interest_errors,
    edgecolor="black",
    color=colors,
    capsize=0,
)
add_bars_with_annotations(ax3, philosophical_interest, philosophical_interest_errors, colors)
ax3.set_title(titles[2])
ax3.set_xlabel(xlabels[2])
ax3.xaxis.grid(True, linestyle="--")
ax3.spines["right"].set_visible(False)
ax3.spines["top"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("errorbar_83.pdf", bbox_inches="tight")
