
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)  # For reproducibility

# Data representing weather statistics for three different cities
cities = ["New York", "Los Angeles", "Chicago"]
metrics = ["Temperature", "Humidity", "Wind Speed", "Precipitation"]
performance = np.array([
    [68, 55, 12, 3],
    [75, 65, 8, 1],
    [60, 70, 15, 5],
])
errors = np.array([
    [5, 4, 3, 0.5],
    [4, 6, 2, 0.2],
    [6, 5, 4, 1],
])
ylim = [0, 80]
ylabel = "Units"
legendlabels = ["Temperature (°F)", "Humidity (%)", "Wind Speed (mph)", "Precipitation (in)"]
suptitle = "Weather Statistics for Selected Cities"
filename = "errorbar_19_8.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axes = plt.subplots(3, 1, figsize=(10, 9), sharex=True)
colors = ["#3498db", "#2ecc71", "#e67e22", "#9b59b6"]  # New color scheme reflecting the weather domain

# Plotting bars
for i, ax in enumerate(axes):
    for j, metric in enumerate(metrics):
        ax.bar(
            j,
            performance[i, j],
            width=0.8,
            color=colors[j],
            yerr=errors[i, j],
            capsize=5,
            label=metric if i == 0 else "",
        )

    # Setting x-axis labels, y-axis limits, and titles for each subplot
    ax.set_xticks(range(len(metrics)))
    ax.set_xticklabels(metrics, rotation=45)
    ax.set_ylim(ylim)
    ax.set_xlabel(f"({chr(97+i)}) {cities[i]}")
    ax.set_ylabel(ylabel)
    ax.yaxis.grid(True)
    ax.set_axisbelow(True)

# Adding a legend outside of the plot on top
fig.legend(legendlabels, loc="upper center", bbox_to_anchor=(0.5, 1.05), ncol=len(metrics))

# Adding a suptitle to the figure
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.96])  # Adjust layout to make space for the suptitle
plt.savefig("errorbar_87.pdf", bbox_inches="tight")
