
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Literature data for different book genres
genres = ["Fiction", "Non-Fiction", "Fantasy", "Mystery"]
x = np.arange(len(genres))  # Location of labels on the x-axis

# Simplifying data arrays to two periods per metric
pages = np.array(
    [np.random.uniform(300, 500, 4), np.random.uniform(200, 400, 4)]
).T  # Classics and Modern pages
readership = np.array(
    [np.random.uniform(1000, 5000, 4), np.random.uniform(5000, 10000, 4)]
).T  # Classics and Modern readership
publication_year = np.array(
    [np.random.uniform(1900, 1950, 4), np.random.uniform(2000, 2020, 4)]
).T  # Classics and Modern publication years
citations = np.array(
    [np.random.uniform(50, 200, 4), np.random.uniform(10, 100, 4)]
).T  # Classics and Modern citations
# Errors for each period
pages_errors = np.array([np.random.randint(20, 50, 4), np.random.randint(15, 30, 4)]).T
readership_errors = np.array([np.random.randint(100, 500, 4), np.random.randint(100, 500, 4)]).T
year_errors = np.array([np.random.randint(2, 5, 4), np.random.randint(1, 3, 4)]).T
citations_errors = np.array([np.random.randint(5, 15, 4), np.random.randint(2, 10, 4)]).T
labels = ["Classics", "Modern"]
titles = [
    "Average Number of Pages",
    "Average Readership",
    "Average Publication Year",
    "Average Author Citations",
]
ylabels = ["Pages", "Readership", "Year", "Citations"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axs = plt.subplots(2, 2, figsize=(10, 5))  # Adjusted to 2 rows and 2 columns
axs = axs.flatten()
# Define colors for each set of bars to keep the design cohesive and attractive
colors = [
    ["#ffcccb", "#ff6666"],  # Classics and Modern for pages
    ["#c2eafc", "#005b96"],  # Classics and Modern for readership
    ["#ffa07a", "#ff4500"],  # Classics and Modern for publication years
    ["#98fb98", "#32cd32"],
]  # Classics and Modern for citations


# Helper function to plot data
def plot_data(ax, j, data, errors, title, ylabel):
    for i in range(2):  # Adjusted to only two bars per genre
        ax.bar(
            x + i * 0.2,
            data[:, i],
            yerr=errors[:, i],
            color=colors[j][i],
            label=labels[i],
            width=0.2,
            capsize=3,
        )
    ax.set_title(title)
    ax.set_xticks(x + 0.1)  # Adjust position to center the group
    ax.set_xticklabels(genres)
    ax.set_ylabel(ylabel)
    ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.4), ncol=2)


# Plot each category of literature data
plot_data(
    axs[0],
    0,
    pages,
    pages_errors,
    titles[0],
    ylabels[0],
)
plot_data(axs[1], 1, readership, readership_errors, titles[1], ylabels[1])
plot_data(axs[2], 2, publication_year, year_errors, titles[2], ylabels[2])
plot_data(axs[3], 3, citations, citations_errors, titles[3], ylabels[3])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_89.pdf", bbox_inches="tight")

