
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Categories and values for different countries
categories = ["Germany", "China", "USA", "India", "Brazil"][::-1]
pending_cases = [-15000, -22000, -18500, -25000, -17000][::-1]  # Number of pending cases
pending_error = [2000, 2500, 2200, 3000, 1800][::-1]  # Error values for pending cases

solved_cases = [14000, 18000, 16000, 22000, 15000][::-1]  # Number of solved cases
solved_error = [1800, 2100, 2000, 2600, 1900][::-1]  # Error values for solved cases
xlabels = ["Pending Cases", "Solved Cases"]
titles = ["Pending Cases by Country", "Solved Cases by Country"]
xlims = [[-30000, 0], [0, 30000]]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart with subplots
fig, axes = plt.subplots(1, 2, figsize=(12, 8), sharey=True)  # Adjust figure size

# Setting colors for the bars
neg_colors = ["#ff9999"] * 5
pos_colors = ["#66b3ff"] * 5

# Plotting bars for negative values (Pending Cases)
bars = axes[0].barh(
    categories,
    pending_cases,
    color=neg_colors,
    edgecolor="black",
    height=0.5,
    xerr=pending_error,
    capsize=5,
)
axes[0].set_xlabel(xlabels[0])
axes[0].set_title(titles[0])
axes[0].invert_yaxis()
axes[0].set_xlim(xlims[0])
axes[0].xaxis.grid(True)
axes[0].spines["top"].set_visible(False)
axes[0].spines["right"].set_visible(False)

# Plotting bars for positive values (Solved Cases)
bars2 = axes[1].barh(
    categories,
    solved_cases,
    color=pos_colors,
    edgecolor="black",
    height=0.5,
    xerr=solved_error,
    capsize=5,
)
axes[1].set_xlabel(xlabels[1])
axes[1].set_title(titles[1])
axes[1].invert_yaxis()
axes[1].set_xlim(xlims[1])
axes[1].xaxis.grid(True)
axes[1].spines["top"].set_visible(False)
axes[1].spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_91.pdf", bbox_inches="tight")
