
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Data for health interventions in different periods
interventions = ["Diet", "Exercise", "Medication"]
effectiveness_1month = [0.35, 0.55, 0.45]  # Effectiveness after 1 month
effectiveness_3months = [0.50, 0.70, 0.60]  # Effectiveness after 3 months
effectiveness_6months = [0.65, 0.80, 0.75]  # Effectiveness after 6 months
error = [0.05, 0.04, 0.03]  # Error margins for the effectiveness values

# Bar positions
x = np.arange(len(interventions))
width = 0.25  # width of the bars

labels = ["1 Month", "3 Months", "6 Months"]
ylabel = "Effectiveness (%)"
title = "Effectiveness of Health Interventions Over Time"
xlabel = "Health Interventions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))
bars1 = ax.bar(
    x - width,
    effectiveness_1month,
    width,
    label=labels[0],
    color="#77B5FE",  # Sky Blue
    yerr=error,
    capsize=5,
    hatch="//",
)
bars2 = ax.bar(
    x,
    effectiveness_3months,
    width,
    label=labels[1],
    color="#98FB98",  # Pale Green
    yerr=error,
    capsize=5,
    hatch="\\",
)
bars3 = ax.bar(
    x + width,
    effectiveness_6months,
    width,
    label=labels[2],
    color="#9370DB",  # Medium Purple
    yerr=error,
    capsize=5,
    hatch="--",
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(interventions)
ax.axhline(0, color="gray")
ax.legend()  # Adjust legend location as needed

# Adding data labels on the bars
def add_labels(bars):
    for bar in bars:
        height = bar.get_height()
        ax.annotate(
            f"{height:.2f}",
            xy=(
                bar.get_x() + bar.get_width() / 2,
                (
                    height + error[bars.index(bar)]
                    if height > 0
                    else height - error[bars.index(bar)]
                ),
            ),
            xytext=(
                0,
                3 if height > 0 else -12,
            ),  # move text up or down based on bar direction
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

add_labels(bars1)
add_labels(bars2)
add_labels(bars3)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("errorbar_94.pdf", bbox_inches="tight")
