
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for technology domain
categories = [
    "Artificial Intelligence",
    "Cybersecurity",
    "Blockchain",
    "Cloud Computing",
    "Internet of Things (IoT)",
    "Quantum Computing",
]
means = np.random.uniform(5, 15, len(categories))
std_devs = np.random.uniform(1, 5, len(categories))
dataset_mean = np.mean(means)

# Labels and Plot Types
xlabel_value = "Technology Sectors"
ylabel_value = "Investment Growth Rate (%)"
label_Mean = "Mean Growth Rate"
label_Dataset_mean = "Overall Mean Growth Rate"
title_value = "Investment Growth Rate Across Technology Sectors"

# Axes Limits and Labels
ylim_values = [0, 20]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Error bar plot
ax.errorbar(
    categories,
    means,
    yerr=std_devs,
    fmt="o",
    color="green",
    ecolor="darkgreen",
    capsize=5,
    markersize=8,
    label=label_Mean,
)

# Dataset mean line
ax.axhline(y=dataset_mean, color="grey", linestyle="--", label=label_Dataset_mean)

# Customizing the plot
ax.set_title(title_value, fontsize=14, fontweight="bold")
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_xticklabels(categories, rotation=45, ha="right", fontsize=10)
ax.legend()
ax.set_ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping of tick-labels
plt.tight_layout()
plt.savefig("errorpoint_23.pdf", bbox_inches="tight")
