
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = ["Sprint", "Marathon", "Javelin", "High Jump", "Pole Vault"]
means = [12.1, 15.2, 13.5, 14.3, 13.8]  # Example average times/distances
errors = [0.5, 1.0, 0.8, 0.6, 0.7]  # Example standard deviation/error
dataset_mean = [13.5]  # Example overall mean
xlabel = "Performance (Time/Distance)"
ylabel = "Sports Categories"
title = "Sports Performance Metrics"
label = "Overall Mean"
color_scheme = "#1f77b4"  # Custom blue color for sports theme
error_color = "#ff7f0e"  # Custom orange color for error bars

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 8))  # Adjust figure size to match the desired dimensions
plt.errorbar(
    means,
    categories,
    xerr=errors,
    fmt="o",
    color=color_scheme,
    ecolor=error_color,
    capsize=5,
    elinewidth=2,
    markeredgewidth=2,
    label="Mean",
)
plt.axvline(dataset_mean, linestyle="--", color="green", label=label)

# Customizing the plot
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorpoint_24.pdf", bbox_inches="tight")
