
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)

# Data for plotting
methods = [
    "Traditional Lecture",
    "Interactive Lecture",
    "Group Discussion",
    "Peer Teaching",
    "Case Study",
    "Role Playing",
    "Simulation",
    "E-learning",
    "Blended Learning",
    "Project-Based Learning"
]
mean_scores = [
    75.3,
    82.1,
    78.5,
    79.8,
    80.2,
    77.0,
    81.1,
    85.3,
    83.2,
    86.5
]
errors = [
    [2.5, -3.5],
    [1.1, -1.4],
    [1.8, -2.0],
    [1.5, -1.9],
    [2.1, -2.5],
    [2.0, -1.8],
    [1.7, -2.2],
    [1.3, -1.0],
    [1.6, -1.9],
    [1.2, -1.4]
]
annotations = [
    r"$%.1f^{+%.1f} _{-%.1f}$" % (mean_scores[i], errors[i][0], abs(errors[i][1])) 
    for i in range(len(mean_scores))
]
xticks = np.arange(70, 90, 2)
xlim = [70, 90]
xvline = 80
xvspan = [78, 82]

# Chart labels
xlabel = "Mean Score"
title = "Performance Metrics of Teaching Methods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 8))

# Error bars with different positive and negative values
for i, (method, mean_score, error, annotation) in enumerate(zip(methods, mean_scores, errors, annotations)):
    ax.errorbar(
        mean_score,
        i,
        xerr=[[abs(error[1])], [error[0]]],
        fmt="o",
        color="#1f77b4",  # Custom color scheme
        ecolor="#ff7f0e",  # Custom error color
        capsize=5,
    )
    ax.text(
        mean_score,
        i - 0.15,
        annotation,
        va="center",
        ha="center",
        fontsize=9,
    )

# Highlighted region with custom color and alpha
ax.axvspan(xvspan[0], xvspan[1], color="lightgreen", alpha=0.3, label="Target Range")

# Text for methods with adjusted font size
# for i, method in enumerate(methods):
#     ax.text(xlim[0], i, method, va="center", ha="left", fontsize=11)

# Set labels and title
ax.set_yticks(range(len(methods)))
ax.set_yticklabels(methods)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_xlim(xlim)
ax.invert_yaxis()  # Invert y-axis to match the original image
ax.axvline(x=xvline, linestyle="--", color="red", label='Threshold Value')

# Adjust x-axis ticks and labels
ax.set_xticks(xticks)
ax.set_xticklabels([f"{x:.1f}" for x in xticks])
ax.set_title(title, fontsize=14)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_28.pdf", bbox_inches="tight")
