
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New Data for plotting
authors = [
    "Research A",
    "Research B",
    "Research C",
    "Research D",
    "Research E",
    "Research F",
    "Research G",
    "Research H",
    "Research I",
    "Research J",
]
values = [
    -20.1,
    -20.4,
    -20.5,
    -20.2,
    -20.3,
    -20.4,
    -20.5,
    -20.6,
    -20.0,
    -20.7,
]
errors = [
    [0.1, -0.1],
    [0.2, -0.2],
    [0.3, -0.3],
    [0.15, -0.15],
    [0.25, -0.25],
    [0.18, -0.18],
    [0.2, -0.2],
    [0.22, -0.22],
    [0.1, -0.1],
    [0.3, -0.3],
]
methods = [
    "Method 1",
    "Method 2",
    "Method 3",
    "Method 4",
    "Method 5",
    "Method 6",
    "Method 7",
    "Method 8",
    "Method 9",
    "Method 10",
]
xticks = np.arange(-21.2, -19.5, 0.2)
xlim = [-21.2, -19.5]
xvline = -20.25
xvspan = [-20.4, -20.1]
# Labels
xlabel = r"$M_B$ Value"
title = "Comparison of Different Research Outcomes"
supertitle = "Scientific Study Results"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 8))

# Error bars with different positive and negative values
for i, (author, value, error) in enumerate(zip(authors, values, errors)):
    ax.errorbar(
        value,
        i,
        xerr=[[abs(error[1])], [error[0]]],
        fmt="o",
        color="#2E8B57",
        ecolor="#8B0000",
        capsize=3,
    )
    ax.text(
        value,
        i - 0.15,
        r"$%.1f^{+%.1f} _{-%.1f}$" % (value, error[0], abs(error[1])),
        va="center",
        ha="center",
        fontsize=9,
        color="#4B0082"
    )

# Highlighted region with adjusted color and alpha
ax.axvspan(xvspan[0], xvspan[1], color="#FFD700", alpha=0.3)

# Text for methods with adjusted font size
for i, method in enumerate(methods):
    ax.text(-19.45, i, method, va="center", ha="left", fontsize=11, color="#4682B4")

# Set labels and title
ax.set_yticks(range(len(authors)))
ax.set_yticklabels(authors, fontsize=12, color="#191970")
ax.set_xlabel(xlabel, fontsize=12, color="#191970")
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xlim(xlim)
ax.invert_yaxis()  
ax.axvline(x=xvline, linestyle="--", color="#FF6347")
# Adjust x-axis ticks and labels
ax.set_xticks(xticks)
ax.set_xticklabels([f"{x:.1f}" for x in xticks], fontsize=10, color="#191970")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save/show the plot
plt.suptitle(supertitle, fontsize=16, fontweight='bold')
plt.tight_layout()
plt.savefig("errorpoint_29.pdf", bbox_inches="tight")
