
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for Education domain
categories = [
    "Curriculum",
    "Sports",
    "Arts",
    "Technology",
    "Teachers",
    "Administration",
]
unique_speaker_mean = [22, 15, 18, 30, 25, 20]  # Example mean values
unique_shouter_mean = [8, 5, 6, 10, 7, 6]  # Example mean values
unique_speaker_error = [2, 1.8, 2.5, 3, 2.2, 2]  # Example error values
unique_shouter_error = [1, 0.8, 1, 1.5, 1.2, 1]  # Example error values

# Labels and text
labels = ["Unique Speaker Mean", "Unique Shouter Mean"]
ylabel = "Number of Speeches"
axlabel = "Average Unique Shouter Count"
xlabel = "Categories"
title = "Speeches in Different Educational Categories"
supertitle = "Analysis of Speaker and Shouter Distribution in Education"
legendlabels = ["Mean Speaker Count", "Mean Shouter Count", axlabel]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))
ax.errorbar(
    categories,
    unique_speaker_mean,
    yerr=unique_speaker_error,
    fmt="s",
    color="#66c2a5",  # Green shade for speakers
    label=labels[0],
    capsize=5,
    linestyle='-', 
    linewidth=2
)
ax.errorbar(
    categories,
    unique_shouter_mean,
    yerr=unique_shouter_error,
    fmt="^",
    color="#fc8d62",  # Orange shade for shouters
    label=labels[1],
    capsize=5,
    linestyle='--', 
    linewidth=2
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
fig.suptitle(supertitle, fontsize=14)
ax.set_xticklabels(categories, rotation=45, ha="right")

# Add horizontal line for average shouter mean
ax.axhline(y=np.mean(unique_shouter_mean), color="#8da0cb", linestyle="--", label=axlabel)

ax.legend(title="Legend", loc="upper left")

# Additional tweaks
ax.grid(True, linestyle=':', linewidth=0.6)
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
# Save and Show plot
plt.savefig("errorpoint_32.pdf", bbox_inches="tight")
