
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# example data for CO2 emissions over years
years = np.arange(2000, 2020, 1)
co2_levels = 300 + 2 * (years - 2000) + np.random.normal(0, 12, len(years))
error = 5 + 0.2 * np.abs(years - 2000)
lower_error = 0.3 * error
upper_error = error
asymmetric_error = [lower_error, upper_error]

title1 = "CO2 Emissions with Symmetric Error"
title2 = "CO2 Emissions with Asymmetric Error"
xlabel = "Year"
ylabel = "CO2 Levels (ppm)"
legend_label = "CO2 Emission Data"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(figsize=(12, 6), ncols=2, sharex=True)

ax0.errorbar(years, co2_levels, yerr=error, fmt="o", color="#2a9d8f", ecolor="#e76f51", elinewidth=2, capsize=4, label=legend_label)
ax0.set_title(title1)
ax0.set_xlabel(xlabel)
ax0.set_ylabel(ylabel)
ax0.legend()

ax1.errorbar(years, co2_levels, xerr=asymmetric_error, fmt="o", color="#264653", ecolor="#e9c46a", elinewidth=2, capsize=4, label=legend_label)
ax1.set_title(title2)
ax1.set_xlabel(xlabel)
ax1.set_yscale("log")
ax1.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_39.pdf", bbox_inches="tight")
